<?php
/**
*
* @package Quote User Back Link
* @version $Id$
* @copyright (c) 2008 Erik Frèrejean ( N/A ) http://www.erikfrerejean.nl
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

/**
* Render the username
*/
function qubl_parse (&$username)
{
	global $db;
	
	static $user_parsed = array();
	
	// Clean the username
	$username_clean = utf8_clean_string($username);

	// Only render once per username
	if (isset($user_parsed[$username_clean]))
	{
		$username = $user_parsed[$username_clean];
		return;
	}

	$sql = 'SELECT user_id, username, user_colour
		FROM ' . USERS_TABLE . "
		WHERE username_clean = '" . $db->sql_escape(utf8_clean_string($username_clean)) . "'";

	$result = $db->sql_query_limit($sql, 1, 0);
	$user	= $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	
	// If this is a guest user we overwrite this data with the data of Anonymous
	if (!$user)
	{
		$sql = 'SELECT user_id, username, user_colour
			FROM ' . USERS_TABLE . '
			WHERE user_id = ' . (int) ANONYMOUS;
		$result	= $db->sql_query_limit($sql, 1, 0);
		$user	= $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		
		$user_parsed[$username_clean] = get_username_string('full', $user['user_id'], $user['username'], $user['user_colour'], $username);
	}
	else
	{
		$user_parsed[$username_clean] = get_username_string('full', $user['user_id'], $user['username'], $user['user_colour']);
	}
	
	$username = $user_parsed[$username_clean];
}
?>
